<?php
$listFilename = 'kw.txt';
$articleFilename = 'deskripsi.txt';
$titleFilename = 'title.txt';

function createIndexContent($folderName, $titleContent, $articleContent) {
    return <<<HTML


<!DOCTYPE html>
<html amp lang="id">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>$titleContent</title>
    <meta name="description" content="$articleContent">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://ramasari.desa.id/item/$folderName">
    <link rel="icon" href="https://pub-2ec04c6e81854b6d9d938cb44b1e247f.r2.dev/djfav.png" type="image/x-icon">
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <script async custom-element="amp-carousel" src="https://cdn.ampproject.org/v0/amp-carousel-0.2.js"></script>
    <style amp-boilerplate>
      body {
        -webkit-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -moz-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        -ms-animation: -amp-start 8s steps(1, end) 0s 1 normal both;
        animation: -amp-start 8s steps(1, end) 0s 1 normal both
      }

      @-webkit-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-moz-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-ms-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @-o-keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }

      @keyframes -amp-start {
        from {
          visibility: hidden
        }

        to {
          visibility: visible
        }
      }
    </style>
    <noscript>
      <style amp-boilerplate>
        body {
          -webkit-animation: none;
          -moz-animation: none;
          -ms-animation: none;
          animation: none
        }
      </style>
    </noscript>
    <style amp-custom>
      body {
        background: url(https://i.postimg.cc/7PtwGz3C/Untitled-design-2.png);
        background-attachment: fixed;
        background-position: top;
        background-size: cover
      }

      p {
        line-height: 18px;
        margin: 15px 0
      }

      .fun,
      .log,
      header {
        display: flex
      }

      .bottom,
      header {
        position: fixed;
        max-width: 100%
      }

      .bottom,
      .container,
      .container img,
      .fun,
      .se,
      header {
        max-width: 100%
      }

      .bubble,
      .eg,
      .log button,
      .menu {
        cursor: pointer
      }

      .bubble,
      .container,
      .fun,
      footer {
        box-sizing: border-box
      }

      .bottom,
      .centerbyv,
      h1,
      h2,
      h3,
      h4,
      h5 {
        text-align: center
      }

      * {
        margin: 0;
        padding: 0;
        font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif
      }

      body {
        background-color: #000
      }

      header {
        width: 100%;
        background-color: #b30000;
        justify-content: space-between;
        top: 0
      }

      .fun {
        width: 250px;
        background-color: #474747;
        border-radius: 10px;
        justify-content: center;
        margin: -9px 0 0 -17px;
        padding: 20px 10px 20px;
        transform: skewY(-3deg) skewX(-17deg)
      }

      .eg:hover,
      .inside {
        background-color: #750101
      }

      header img {
        max-width: 200px;
        transform: skewY(3deg) skewX(17deg)
      }

      .log {
        justify-content: center;
        align-items: center;
        width: 200px
      }

      .bubble,
      .se {
        justify-content: space-between;
        display: flex
      }

      .log button {
        width: 150px;
        height: 40px;
        border-radius: 5px;
        border: transparent;
        color: #fff;
        font-size: 15px;
        font-weight: bolder;
        background: linear-gradient(to bottom, #e20303 0, #5c0101 100%)
      }

      .xd img:hover,
      .bubble:hover,
      .log button:hover {
        border: 2px solid #e7e7e7
      }

      .container {
        width: 500px;
        margin: 90px auto auto;
        padding: 5px
      }

      .inside {
        border-radius: 7px;
        padding: 7px
      }

      .bubble {
        background-color: #3f0202;
        border-radius: 5px;
        margin: 10px 5px;
        font-weight: 700;
        color: #fff;
        padding: 5px;
        border: 2px solid transparent
      }

      .bottom,
      .eg {
        background: linear-gradient(to bottom, #e20303 0, #411515 100%)
      }

      .eg,
      .inside span {
        font-weight: bolder;
        color: #fff
      }

      .bubble img {
        max-width: 90px
      }

      .server {
        display: flex;
        justify-content: center;
        flex-wrap: wrap
      }

      .se {
        width: 1000px;
        margin: 4px 2px
      }

      .eg {
        border: 2px solid #e7e7e7;
        color: #fff;
        border-radius: 5px;
        width: 240px;
        height: 50px;
        font-size: 18px
      }

      .hot-server {
        background-image: #b30000
      }

      .bottom {
        bottom: 0;
        height: 51px;
        left: 0;
        right: 0;
        display: flex;
        justify-content: space-between;
        color: #fff;
        font-size: 10px;
        align-items: center
      }

      .menu {
        width: 80px
      }

      .centerbyv {
        margin-bottom: 10px
      }

      .menu img {
        max-width: 25px
      }

      .xd {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-around;
        align-items: center
      }

      .xd img {
        max-width: 128px;
        border-radius: 10px;
        margin-top: 5px;
        border: 2px solid transparent
      }

      .middle {
        margin: 20px
      }

      footer {
        text-align: justify;
        color: #fff;
        border: 1px solid #2283f6;
        border-radius: 5px;
        margin: 10px 5px 60px;
        padding: 15px;
        font-size: 15px
      }

      footer a {
        color: #fff
      }

      .bottom a {
        text-decoration: none;
        color: #fff
      }

      @media screen and (max-width:500px) {
        .eg {
          width: 190px;
          transition: .5s
        }

        .se {
          justify-content: space-around
        }

        .xd img {
          max-width: 100px
        }
      }

      @media screen and (max-width:425px) {
        .eg {
          width: 170px
        }
      }

      @media screen and (max-width:375px) {
        .eg {
          width: 150px
        }
      }

      li {
        margin-left: 20px
      }

      h2,
      h3,
      h4,
      h5 {
        text-align: left
      }
    </style>
  </head>
  <body>
    <header>
      <div class="fun">
        <img src="https://pub-2ec04c6e81854b6d9d938cb44b1e247f.r2.dev/LOGO%20DOJO77%20GIF-KILAU.gif">
      </div>
    </header>
    <div class="container">
      <div class="inside">
        <div class="server">
          <div class="se">
            <a href="https://t.ly/dojo77new" target="_blank">
              <button class="eg hot-server" style="font-size:12pt">DAFTAR</button>
            </a>
            <a href="https://t.ly/dojo77new" target="_blank">
              <button class="eg hot-server" style="font-size:12pt">MASUK</button>
            </a>
          </div>
        </div>
        <div class="centerbyv">
          <a href="" target="_self">
            <img style="border-radius:10px" src="https://pub-2ec04c6e81854b6d9d938cb44b1e247f.r2.dev/tolakrungkad.png" alt="Slot Gacor" title="Slot Gacor" width="100%">
          </a>
        </div>
        <div class="bubble">
          <div class="middle">LINK GACOR</div>
          <div class="log">
            <a href="https://t.ly/dojo77new">
              <button class="daftar">LOGIN</button>
            </a>
          </div>
        </div>
        <div class="bubble">
          <div class="middle">SITUS GACOR</div>
          <div class="log">
            <a href="https://t.ly/dojo77new">
              <button class="daftar">LOGIN</button>
            </a>
          </div>
        </div>
        <div class="bubble">
          <div class="middle">RTP JACKPOT</div>
          <div class="log">
            <a href="https://t.ly/dojo77new">
              <button class="daftar">LOGIN</button>
            </a>
          </div>
        </div>
      </div>
    </div>
  </body>
</html>

HTML;
}

if (file_exists($articleFilename)) {
    $articleContents = file($articleFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
} else {
    die("File '$articleFilename' tidak ditemukan.");
}

if (file_exists($titleFilename)) {
    $titleContents = file($titleFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
} else {
    die("File '$titleFilename' tidak ditemukan.");
}

if (file_exists($listFilename)) {
    $folderNames = file($listFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($folderNames as $folderName) {
        $folderName = trim($folderName);

        if (!is_dir($folderName)) {
            if (mkdir($folderName)) {
                echo "Folder '$folderName' berhasil dibuat.<br>";
                
                $randomArticle = $articleContents[array_rand($articleContents)];
                $randomTitle = $titleContents[array_rand($titleContents)];

                $randomArticle = str_replace('COKLAT', $folderName, $randomArticle);
                $randomTitle = str_replace('COKLAT', $folderName, $randomTitle);
                
                $indexContent = createIndexContent($folderName, $randomTitle, $randomArticle);
                $indexPath = $folderName . DIRECTORY_SEPARATOR . 'index.html';
                if (file_put_contents($indexPath, $indexContent)) {
                    echo "File index.html berhasil dibuat di folder '$folderName'.<br>";
                } else {
                    echo "Gagal membuat file index.html di folder '$folderName'.<br>";
                }
            } else {
                echo "Gagal membuat folder '$folderName'.<br>";
            }
        } else {
            echo "Folder '$folderName' sudah ada.<br>";
        }
    }
} else {
    echo "File '$listFilename' tidak ditemukan.";
}
?>